/**
* \file: model_internal.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMM_MODEL_MODEL_INTERNAL_H
#define AMM_MODEL_MODEL_INTERNAL_H

#include "backends/device_handler.h"
#include "model/partition.h"
#include "model/partition_metadata.h"
#include "model/device.h"
#include "model/device_metadata.h"

typedef struct partition_t
{
	char *id;

	char *mount_point;

	bool mounted_writable;

	partition_state_t state;

	device_t *device;

	error_code_t error;

	partition_unsupported_reason_t unsupported_reason;

	partition_metadata_t *metadata;

	partition_state_change_callback_t state_change_callback_func;

	void *state_change_callback_data;

	partition_t *next_partition;

	partition_t *previous_partition;
} partition_t;

typedef struct device_t
{
	char *id;

	device_state_t state;

	int detected_partition_cnt;

	int expected_partition_cnt;

	device_metadata_t *metadata;

    device_state_change_callback_t state_change_callback_func;

    void *state_change_callback_data;

    devicehandler_vtable_t *device_vtable;

	partition_t partition_list_head;

	device_t *next_device;

	device_t *previous_device;

} device_t;

partition_t *partition_create_new(const char* partition_id,
		device_t* device, partition_metadata_t *metadata);

void partition_free(partition_t *partition);



device_t *device_create_new(const char* device_id, device_metadata_t *metadata,
		devicehandler_vtable_t *vtable);

void device_free(device_t *device);

#endif
